/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.client;

import java.util.HashMap;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.util.Coord;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class Renderer {
    public static final HashMap<Integer, ItemStack[]> dataMap = new HashMap();

    @ForgeSubscribe
    public void renderEvent(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71446_o == null || RenderManager.field_78727_a == null || RenderManager.field_78727_a.func_78716_a() == null || mc.field_71474_y.field_74320_O != 0 || mc.field_71476_x == null) {
            return;
        }
        Coord coord = new Coord(mc.field_71441_e.field_73011_w.field_76574_g, mc.field_71476_x);
        switch (mc.field_71476_x.field_72313_a) {
            case TILE: {
                if (dataMap.containsKey(coord.hashCode())) break;
                return;
            }
            case ENTITY: {
                if (dataMap.containsKey(mc.field_71476_x.field_72308_g.field_70157_k)) break;
                return;
            }
        }
        try {
            this.renderHologram(mc, coord);
        }
        catch (Exception e) {
            System.out.println("HoloInventory had an unexpected issue... Please make an issue on github for this.");
            e.printStackTrace();
        }
    }

    public void renderHologram(Minecraft mc, Coord coord) throws Exception {
        ItemStack[] itemStacks = dataMap.get(coord.hashCode());
        if (itemStacks.length == 0) {
            return;
        }
        double distance = this.distance(coord);
        if (distance < 2.0) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)coord.x + 0.5 - RenderManager.field_78725_b), (double)((double)coord.y + 0.5 - RenderManager.field_78726_c), (double)((double)coord.z + 0.5 - RenderManager.field_78723_d));
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)0.5f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
        float timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
        EntityItem customitem = new EntityItem((World)mc.field_71441_e);
        customitem.field_70290_d = 0.0f;
        int maxCollums = itemStacks.length > 9 ? 9 : itemStacks.length;
        int maxRows = itemStacks.length % 9 == 0 ? itemStacks.length / 9 - 1 : itemStacks.length / 9;
        float blockScale = 0.2f + (float)((double)0.1f * distance);
        float maxWith = (float)maxCollums * blockScale * 0.7f * 0.4f;
        float maxHeight = (float)maxRows * blockScale * 0.7f * 0.4f;
        this.renderBG(blockScale, maxWith, maxHeight);
        int collum = 0;
        int row = 0;
        for (ItemStack item : itemStacks) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            this.translateAndScale(blockScale, collum, maxWith, row, maxHeight);
            GL11.glRotatef((float)timeD, (float)0.0f, (float)1.0f, (float)0.0f);
            customitem.func_92058_a(item);
            HoloInventory.instance.clientHandler.itemRenderer.func_77014_a(customitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
            if (++collum < 9) continue;
            collum = 0;
            ++row;
        }
        collum = 0;
        row = 0;
        for (ItemStack item : itemStacks) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            this.translateAndScale(blockScale, collum, maxWith, row, maxHeight);
            GL11.glScalef((float)0.03f, (float)0.03f, (float)0.03f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-1.0f, (float)1.0f, (float)0.0f);
            if (item.field_77994_a < 10) {
                GL11.glTranslatef((float)6.0f, (float)0.0f, (float)0.0f);
            }
            if (item.field_77994_a > 99) {
                GL11.glTranslatef((float)-6.0f, (float)0.0f, (float)0.0f);
            }
            if (item.field_77994_a > 999) {
                GL11.glTranslatef((float)6.0f, (float)0.0f, (float)0.0f);
            }
            if (item.field_77994_a > 9999) {
                GL11.glTranslatef((float)-6.0f, (float)0.0f, (float)0.0f);
            }
            RenderManager.field_78727_a.func_78716_a().func_85187_a(item.field_77994_a > 999 ? item.field_77994_a / 1000 + "K" : item.field_77994_a + "", 0, 0, -1426063361, true);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            if (++collum < 9) continue;
            collum = 0;
            ++row;
        }
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    private void translateAndScale(float blockScale, int collum, float maxWith, int row, float maxHeight) {
        GL11.glTranslatef((float)(maxWith - ((float)collum + 0.2f) * blockScale * 0.6f), (float)(maxHeight - ((float)row + 0.05f) * blockScale * 0.6f), (float)0.0f);
        GL11.glScalef((float)blockScale, (float)blockScale, (float)blockScale);
    }

    public void renderBG(float blockScale, float maxWith, float maxHeight) {
        if (!HoloInventory.instance.config.colorEnable) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        Tessellator tess = Tessellator.field_78398_a;
        Tessellator.renderingWorldRenderer = false;
        tess.func_78371_b(7);
        tess.func_78370_a(HoloInventory.instance.config.colorR, HoloInventory.instance.config.colorG, HoloInventory.instance.config.colorB, HoloInventory.instance.config.colorAlpha);
        double d = blockScale / 3.0f;
        tess.func_78377_a((double)maxWith + d, -d - (double)maxHeight, 0.0);
        tess.func_78377_a((double)(-maxWith) - d, -d - (double)maxHeight, 0.0);
        tess.func_78377_a((double)(-maxWith) - d, d + (double)maxHeight, 0.0);
        tess.func_78377_a((double)maxWith + d, d + (double)maxHeight, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public double distance(Coord coord) {
        return Math.sqrt(((double)coord.x + 0.5 - RenderManager.field_78725_b) * ((double)coord.x + 0.5 - RenderManager.field_78725_b) + ((double)coord.y + 0.5 - RenderManager.field_78726_c) * ((double)coord.y + 0.5 - RenderManager.field_78726_c) + ((double)coord.z + 0.5 - RenderManager.field_78723_d) * ((double)coord.z + 0.5 - RenderManager.field_78723_d));
    }
}

