/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.lib.developercapes;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import net.dries007.holoInventory.lib.developercapes.DevCapesImageBufferDownload;
import net.dries007.holoInventory.lib.developercapes.DevCapesTickHandler;
import net.dries007.holoInventory.lib.developercapes.DevCapesVersionChecker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureObject;
import net.minecraft.util.ResourceLocation;

public class DevCapes {
    private static DevCapes instance;
    public static final double version = 2.1;
    public DevCapesVersionChecker versionChecker;
    private HashMap<String, String> users = new HashMap();
    private HashMap<String, ResourceLocation> capeResources = new HashMap();
    private HashMap<String, ThreadDownloadImageData> downloadThreads = new HashMap();
    private DevCapesTickHandler tickHandler = null;

    private DevCapes() {
        this.versionChecker = new DevCapesVersionChecker();
        Thread vc = new Thread(this.versionChecker);
        vc.setDaemon(true);
        vc.setName("DevCapesVersionChecker");
        vc.run();
    }

    public static DevCapes getInstance() {
        if (instance == null) {
            instance = new DevCapes();
        }
        return instance;
    }

    public void addFileUrl(String parTxtUrl) {
        try {
            String line;
            URL url = new URL(parTxtUrl);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String username = "";
            String group = "";
            String capeUrl = "";
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                for (int i = 0; i < line.length(); ++i) {
                    if (line.charAt(i) != '=') continue;
                    group = line.substring(0, i);
                    String subLine = line.substring(i + 1);
                    if (subLine.startsWith("http")) {
                        capeUrl = subLine;
                        ResourceLocation r = new ResourceLocation("DevCapes/" + group);
                        ThreadDownloadImageData t = DevCapes.makeDownloadThread(r, capeUrl, null, new DevCapesImageBufferDownload());
                        this.addCapeResource(group, r);
                        this.addDownloadThread(group, t);
                        continue;
                    }
                    username = subLine.toLowerCase();
                    this.addUser(username, group);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.tickHandler == null) {
            this.tickHandler = new DevCapesTickHandler();
            TickRegistry.registerTickHandler((ITickHandler)this.tickHandler, (Side)Side.CLIENT);
        }
    }

    public void addUser(String parUsername, String parGroup) {
        if (this.getUserGroup(parUsername) == null) {
            this.users.put(parUsername, parGroup);
        }
    }

    public String getUserGroup(String parUsername) {
        return this.users.get(parUsername.toLowerCase());
    }

    public void addCapeResource(String parGroup, ResourceLocation parResource) {
        if (this.getCapeResource(parGroup) == null) {
            this.capeResources.put(parGroup, parResource);
        }
    }

    public ResourceLocation getCapeResource(String parGroup) {
        return this.capeResources.get(parGroup);
    }

    public void addDownloadThread(String parGroup, ThreadDownloadImageData parResource) {
        if (this.getDownloadThread(parGroup) == null) {
            this.downloadThreads.put(parGroup, parResource);
        }
    }

    public ThreadDownloadImageData getDownloadThread(String parGroup) {
        return this.downloadThreads.get(parGroup);
    }

    public static ThreadDownloadImageData makeDownloadThread(ResourceLocation par0ResourceLocation, String par1Str, ResourceLocation par2ResourceLocation, IImageBuffer par3IImageBuffer) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ThreadDownloadImageData object = new ThreadDownloadImageData(par1Str, par2ResourceLocation, par3IImageBuffer);
        texturemanager.func_110579_a(par0ResourceLocation, (TextureObject)object);
        return object;
    }
}

