/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.server;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.HashMap;
import net.dries007.holoInventory.util.Coord;
import net.dries007.holoInventory.util.Helper;
import net.dries007.holoInventory.util.InventoryData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.WorldServer;

public class TickHandler
implements ITickHandler {
    public HashMap<Integer, InventoryData> blockMap = new HashMap();

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        EntityPlayerMP player = (EntityPlayerMP)tickData[0];
        WorldServer world = player.func_71121_q();
        if (world == null) {
            return;
        }
        MovingObjectPosition mo = Helper.getPlayerLookingSpot((EntityPlayer)player);
        if (mo != null) {
            switch (mo.field_72313_a) {
                case TILE: {
                    Coord coord = new Coord(world.field_73011_w.field_76574_g, mo);
                    TileEntity te = world.func_72796_p(coord.x, coord.y, coord.z);
                    if (te instanceof IInventory) {
                        this.doStuff(coord.hashCode(), (IInventory)te, player);
                        break;
                    }
                    if (!(te instanceof TileEntityEnderChest)) break;
                    this.doStuff(coord.hashCode(), (IInventory)player.func_71005_bN(), player);
                    break;
                }
                case ENTITY: {
                    System.out.println(mo.field_72308_g.field_70157_k);
                    if (!(mo.field_72308_g instanceof IInventory)) break;
                    this.doStuff(mo.field_72308_g.field_70157_k, (IInventory)mo.field_72308_g, player);
                }
            }
        }
    }

    private void doStuff(int id, IInventory inventory, EntityPlayerMP player) {
        boolean empty = this.idEmpty(inventory);
        if (empty && !this.blockMap.containsKey(id)) {
            return;
        }
        InventoryData inventoryData = this.blockMap.get(id);
        if (inventoryData == null || inventoryData.isOld((EntityPlayer)player) || empty) {
            inventoryData = new InventoryData(inventory, id);
            inventoryData.send(player);
            this.blockMap.put(id, inventoryData);
        }
        if (empty && this.blockMap.containsKey(id)) {
            this.blockMap.remove(id);
        }
    }

    private boolean idEmpty(IInventory te) {
        for (int i = 0; i < te.func_70302_i_(); ++i) {
            if (te.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "HoloInventory_ServerTickHandler";
    }

    public void clear() {
        this.blockMap.clear();
    }
}

