/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;

public class Coord {
    public int dim;
    public int x;
    public int y;
    public int z;

    public Coord(int dim, int x, int y, int z) {
        this.dim = dim;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord(int dim, MovingObjectPosition mop) {
        this.dim = dim;
        switch (mop.field_72313_a) {
            case TILE: {
                this.x = mop.field_72311_b;
                this.y = mop.field_72312_c;
                this.z = mop.field_72309_d;
                break;
            }
            case ENTITY: {
                this.x = mop.field_72308_g.field_70176_ah;
                this.y = mop.field_72308_g.field_70162_ai;
                this.z = mop.field_72308_g.field_70164_aj;
            }
        }
    }

    public Coord(int hash) {
        this.dim = hash >> 24;
        this.y = (hash >> 16) - (this.dim << 24);
        this.z = (hash >> 8) - (this.dim << 24) - (this.y << 16);
        this.x = hash - (this.dim << 24) - (this.y << 16) - (this.z << 8);
    }

    public Coord(NBTTagCompound coord) {
        this.dim = coord.func_74762_e("dim");
        this.x = coord.func_74762_e("x");
        this.y = coord.func_74762_e("y");
        this.z = coord.func_74762_e("z");
    }

    public Coord offset(int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        this.x = dir.offsetX;
        this.y = dir.offsetY;
        this.z = dir.offsetZ;
        return this;
    }

    public int hashCode() {
        return this.x + (this.z << 8) + (this.y << 16) + (this.dim << 24);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coord) {
            Coord coord = (Coord)obj;
            return this.x == coord.x && this.y == coord.y && this.z == coord.z && this.dim == coord.dim;
        }
        return false;
    }
}

